import Utilities.waveform_creator as wc
import Utilities.gui_creator as gc
import Utilities.plot_creator as pc

def calculate_plot_waveform():
    
    control_string = gc.get_control_string(var_ent)
    num_terms = int(control_string)

    num, samp_freq = 3000, 1000
    t = wc.create_time_data(num, samp_freq)
    y = wc.sum_sines(t, num_terms)
    
    
    pc.update_plot(ax, canvas, t ,y, label_x, label_y,
                   marker='-')

    return

title = 'Sum of Sines'
label_x,label_y = 'Time (s)','Displacement'

root = gc.create_window(title)
control_box,right_frame = gc.create_frames(root)

var_ent = gc.create_control(control_box, 'Number of Terms')

ax,canvas = pc.create_plot(right_frame)
pc.update_plot(ax, canvas, [], [], label_x, label_y)

gc.action_button(control_box, label='Submit',
                 action= calculate_plot_waveform)

root.mainloop()
